#!/bin/sh

MASTER_PAGE_SB_INTERNET_CONN_RESULT_MSG=""
MASTER_PAGE_SB_INTERNET_CONN_RESULT_OK=0
MASTER_PAGE_SB_INTERNET_CONN_RESULT_ERROR=1

MASTER_PAGE_SB_INTERNET_CONN_RESULT_CODE=${MASTER_PAGE_SB_INTERNET_CONN_RESULT_ERROR}
MASTER_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=0

internet_enable_on_off() {
	case ${1} in
		$MASTER_PAGE_SB_INTERNET_CONN_ITEM_1) # 'Enable'
			[ "$RT_NAT_INTERNET_CONN" == "0" ] && echo off || echo on
		;;
		$MASTER_PAGE_SB_INTERNET_CONN_ITEM_2) # 'Disable'
			[ "$RT_NAT_INTERNET_CONN" == "0" ] && echo on || echo off
		;;
		*) echo off ;;
	esac
}

master_page_sb_internet_conn() {
	debug_print "in function '${FUNCNAME[0]}'"
	
    # user must disconnect all clusters before reconfiging internet connection for sandboxes
    debug_print "CheckIfAnyClusterExists..."
    local msg
    msg=`php ${CONS_BACKEND} get_cluster_number_from_db`
    ret="${?}"
    if [ "${ret}" -ne 0 ]; then
        debug_print "GetClusterTotalNumberFail: ret='${ret}', msg='${msg}'"
        
        MASTER_PAGE_SB_INTERNET_CONN_RESULT_CODE=$MASTER_PAGE_SB_INTERNET_CONN_RESULT_ERROR
        MASTER_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=-1
        MASTER_PAGE_SB_INTERNET_CONN_RESULT_MSG="${msg}"
        return
        
    elif [ "${msg}" -ne 0 ]; then
        debug_print "ClusterExist: clusterTotalNumber='${msg}'"
        
        MASTER_PAGE_SB_INTERNET_CONN_RESULT_CODE=$MASTER_PAGE_SB_INTERNET_CONN_RESULT_ERROR
        MASTER_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=-1
        MASTER_PAGE_SB_INTERNET_CONN_RESULT_MSG="${MASTER_PAGE_SB_INTERNET_ERROR_REMOVE_CLUSTER_TEXT}"
        return
    fi
    debug_print "ClusterNotExist: ret='${ret}', clusterTotalNumber='${msg}'"
    
    
    debug_print "CheckInternetConnectionSetting: RT_NAT_INTERNET_CONN='${RT_NAT_INTERNET_CONN}'"
    if [ -z "${RT_NAT_INTERNET_CONN}" ]; then
        debug_print "InternetConnectionSetting is empty..."

        conf_nat_internet_conn=`dtascfg "${DTASCFG_XML_FILE}" get nat internet_connection`
        debug_print "read </configuration/nat/internet_connection>: ${conf_nat_internet_conn}"
        
        RT_NAT_INTERNET_CONN="${conf_nat_internet_conn}"
        debug_print "ReloadInternetConnectionSetting: RT_NAT_INTERNET_CONN='${RT_NAT_INTERNET_CONN}'"
    fi
    
	local item_number=2
	local radio_list=""
	for (( i=1; i<=$item_number; i=i+1 ))
	do
			eval radio_item=\$MASTER_PAGE_SB_INTERNET_CONN_ITEM_$i
			radio_list="$radio_list \"$radio_item\" \"\" `internet_enable_on_off "$radio_item"`"
	done
	
    tp_radiolist \
        "${MASTER_PAGE_SB_INTERNET_CONN_TITLE}" \
        "${MASTER_PAGE_SB_INTERNET_CONN_TEXT}" \
        "${MASTER_PAGE_SB_INTERNET_CONN_LABEL_OK}" \
        "${MASTER_PAGE_SB_INTERNET_CONN_LABEL_CANCEL}" \
        "${radio_list}" \
		$item_number

	# no error cases
	MASTER_PAGE_SB_INTERNET_CONN_RESULT_CODE=${MASTER_PAGE_SB_INTERNET_CONN_RESULT_OK}
	
	if [ "${TP_RADIOLIST_RESULT_CODE}" == "${TP_RADIOLIST_RESULT_CANCEL}" ]; then
		MASTER_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=-1
		return
	fi		
    
    debug_print "TP_RADIOLIST_RESULT_SELECT: ${TP_RADIOLIST_RESULT_SELECT}"
	case "${TP_RADIOLIST_RESULT_SELECT}" in
    
        $MASTER_PAGE_SB_INTERNET_CONN_ITEM_1 )
			debug_print "EnableSBInternetConnection... "
			RT_NAT_INTERNET_CONN="1"
            MASTER_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=-1
			MASTER_PAGE_SB_INTERNET_CONN_RESULT_MSG=""
            ;;
        
        $MASTER_PAGE_SB_INTERNET_CONN_ITEM_2 )
			debug_print "DisableSBInternetConnection...."
			RT_NAT_INTERNET_CONN="0"
            MASTER_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=-1
            MASTER_PAGE_SB_INTERNET_CONN_RESULT_MSG=""
            ;;
            
        * )
            MASTER_PAGE_SB_INTERNET_CONN_RESULT_CODE=$MASTER_PAGE_SB_INTERNET_CONN_RESULT_ERROR
            MASTER_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=0
            MASTER_PAGE_SB_INTERNET_CONN_RESULT_MSG="${MASTER_PAGE_SB_INTERNET_CONN_ERROR_UNKNOWN}"
            return
            ;;
    esac
    
    # apply successfully
    debug_print "RT_NAT_INTERNET_CONN: ${RT_NAT_INTERNET_CONN}"
    utility_save_nat_internet_conn_conf \
        "${RT_NAT_INTERNET_CONN}"
    if [ "${?}" -ne 0 ]; then
        MASTER_PAGE_SB_INTERNET_CONN_RESULT_CODE=$MASTER_PAGE_SB_INTERNET_CONN_RESULT_ERROR
        MASTER_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=0
        MASTER_PAGE_SB_INTERNET_CONN_RESULT_MSG="${MASTER_PAGE_SB_INTERNET_CONN_ERROR_SAVE_CONFIGURATION}"
        return
    fi
    
    case "${RT_NAT_INTERNET_CONN}" in
        0 )
            debug_print "DisableSBInternetConnection...."
            
            utility_apply_nat_network_conf_isolated
            if [ "${?}" -ne 0 ]; then
                MASTER_PAGE_SB_INTERNET_CONN_RESULT_CODE=$MASTER_PAGE_SB_INTERNET_CONN_RESULT_ERROR
                MASTER_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=0
                MASTER_PAGE_SB_INTERNET_CONN_RESULT_MSG="${DPLY_PAGE_SB_INTERNET_CONN_ERROR_ISOLATE}: ${UTILITY_APPLY_NAT_NETWORK_CONF_ISOLATED_RESULT_MSG}"
                return
            fi
            
            MASTER_PAGE_SB_INTERNET_CONN_RESULT_CODE=$MASTER_PAGE_ESXI_INFO_CONF_RESULT_OK
            MASTER_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=3
            MASTER_PAGE_SB_INTERNET_CONN_RESULT_MSG=""
            ;;
        1 )
            debug_print "EnableSBInternetConnection... "
            MASTER_PAGE_SB_INTERNET_CONN_RESULT_CODE=$MASTER_PAGE_ESXI_INFO_CONF_RESULT_OK
            MASTER_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=1
            MASTER_PAGE_SB_INTERNET_CONN_RESULT_MSG=""
            ;;
        * )
            MASTER_PAGE_SB_INTERNET_CONN_RESULT_CODE=$MASTER_PAGE_SB_INTERNET_CONN_RESULT_ERROR
            MASTER_PAGE_SB_INTERNET_CONN_RESULT_ROLLING=0
            MASTER_PAGE_SB_INTERNET_CONN_RESULT_MSG="${MASTER_PAGE_SB_INTERNET_CONN_ERROR_UNKNOWN}"
            ;;
    esac
}
